<?php
/**
 * Template Name: Fashion Boutique Home Page
 * 
 * The template for displaying the fashion boutique homepage
 */

get_header(); ?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="hero-content">
        <h1><?php echo esc_html(get_theme_mod('hero_title', 'Elegant Fashion for Modern Women')); ?></h1>
        <p><?php echo esc_html(get_theme_mod('hero_subtitle', 'Discover our curated collection of timeless pieces')); ?></p>
        <a href="<?php echo esc_url(get_theme_mod('hero_button_link', class_exists('WooCommerce') ? wc_get_page_permalink('shop') : '#')); ?>" class="btn btn-primary">
            <?php echo esc_html(get_theme_mod('hero_button_text', 'Shop Now')); ?>
        </a>
    </div>
</section>

<!-- Page Content (if any) -->
<?php while (have_posts()) : the_post(); ?>
    <?php if (get_the_content()) : ?>
    <section class="page-content section-padding">
        <div class="container">
            <div class="entry-content">
                <?php the_content(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
<?php endwhile; ?>

<!-- Featured Products Section -->
<section class="featured-products section-padding">
    <div class="container">
        <div class="section-title">
            <h2>Featured Products</h2>
            <p>Handpicked items from our latest collection</p>
        </div>
        
        <div class="products-grid">
            <?php 
            // Check if WooCommerce is active
            if (class_exists('WooCommerce')) {
                $featured_products = get_featured_products(4);
                
                if (!empty($featured_products)) {
                    foreach ($featured_products as $product_post) {
                        $product = wc_get_product($product_post->ID);
                        ?>
                        <div class="product-card fade-in">
                            <div class="product-image">
                                <?php if (has_post_thumbnail($product_post->ID)) : ?>
                                    <a href="<?php echo get_permalink($product_post->ID); ?>">
                                        <?php echo get_the_post_thumbnail($product_post->ID, 'woocommerce_thumbnail'); ?>
                                    </a>
                                <?php else : ?>
                                    <a href="<?php echo get_permalink($product_post->ID); ?>">
                                        <img src="https://via.placeholder.com/300x400/f8f8f8/333?text=Product" alt="<?php echo esc_attr($product->get_name()); ?>">
                                    </a>
                                <?php endif; ?>
                                
                                <div class="product-overlay">
                                    <a href="<?php echo get_permalink($product_post->ID); ?>" class="quick-add-btn">
                                        View Product
                                    </a>
                                </div>
                            </div>
                            
                            <div class="product-info">
                                <h3 class="product-name">
                                    <a href="<?php echo get_permalink($product_post->ID); ?>">
                                        <?php echo esc_html($product->get_name()); ?>
                                    </a>
                                </h3>
                                
                                <div class="product-price">
                                    <?php echo $product->get_price_html(); ?>
                                </div>
                                
                                <a href="<?php echo esc_url($product->add_to_cart_url()); ?>" class="add-to-cart-btn" data-product-id="<?php echo $product->get_id(); ?>">
                                    Add to Cart
                                </a>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    // Show message to add featured products
                    echo '<div class="no-products-message" style="text-align: center; grid-column: 1 / -1; padding: 60px 20px;">';
                    echo '<h3>No Featured Products Yet</h3>';
                    echo '<p>Please add some products and mark them as "Featured" in your WooCommerce admin to display them here.</p>';
                    if (current_user_can('manage_woocommerce')) {
                        echo '<a href="' . admin_url('post-new.php?post_type=product') . '" class="btn btn-primary">Add Products</a>';
                    }
                    echo '</div>';
                }
            } else {
                // Show WooCommerce installation message
                echo '<div class="no-woocommerce-message" style="text-align: center; grid-column: 1 / -1; padding: 60px 20px;">';
                echo '<h3>WooCommerce Not Installed</h3>';
                echo '<p>This theme requires WooCommerce for full e-commerce functionality.</p>';
                if (current_user_can('install_plugins')) {
                    echo '<a href="' . admin_url('plugin-install.php?s=woocommerce&tab=search&type=term') . '" class="btn btn-primary">Install WooCommerce</a>';
                }
                echo '</div>';
            }
            ?>
        </div>
    </div>
</section>

<!-- Category Cards Section -->
<section class="category-section">
    <div class="container">
        <div class="section-title">
            <h2>Shop by Category</h2>
            <p>Find the perfect style for every occasion</p>
        </div>
        
        <div class="category-grid">
            <?php
            if (class_exists('WooCommerce')) {
                $product_categories = get_product_categories(3);
                
                if (!empty($product_categories)) {
                    $category_images = array(
                        'https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=500&h=600&fit=crop',
                        'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=500&h=600&fit=crop',
                        'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=500&h=600&fit=crop'
                    );
                    
                    $image_index = 0;
                    foreach ($product_categories as $category) {
                        $category_link = get_term_link($category);
                        $category_image = $category_images[$image_index % count($category_images)];
                        $image_index++;
                        ?>
                        <a href="<?php echo esc_url($category_link); ?>" class="category-card">
                            <img src="<?php echo esc_url($category_image); ?>" alt="<?php echo esc_attr($category->name); ?>">
                            <div class="category-overlay">
                                <h3 class="category-title"><?php echo esc_html($category->name); ?></h3>
                                <p class="category-subtitle"><?php echo $category->count; ?> Products</p>
                            </div>
                        </a>
                        <?php
                    }
                } else {
                    // Default demo categories
                    $demo_categories = array(
                        array(
                            'name' => 'Women',
                            'subtitle' => 'Elegant & Contemporary',
                            'image' => 'https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=500&h=600&fit=crop',
                            'link' => class_exists('WooCommerce') ? wc_get_page_permalink('shop') : '#'
                        ),
                        array(
                            'name' => 'Men',
                            'subtitle' => 'Classic & Modern', 
                            'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=500&h=600&fit=crop',
                            'link' => class_exists('WooCommerce') ? wc_get_page_permalink('shop') : '#'
                        ),
                        array(
                            'name' => 'Accessories',
                            'subtitle' => 'Complete Your Look',
                            'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=500&h=600&fit=crop',
                            'link' => class_exists('WooCommerce') ? wc_get_page_permalink('shop') : '#'
                        )
                    );
                    
                    foreach ($demo_categories as $category) {
                        ?>
                        <a href="<?php echo esc_url($category['link']); ?>" class="category-card">
                            <img src="<?php echo esc_url($category['image']); ?>" alt="<?php echo esc_attr($category['name']); ?>">
                            <div class="category-overlay">
                                <h3 class="category-title"><?php echo esc_html($category['name']); ?></h3>
                                <p class="category-subtitle"><?php echo esc_html($category['subtitle']); ?></p>
                            </div>
                        </a>
                        <?php
                    }
                }
            } else {
                // Demo categories when WooCommerce is not installed
                $demo_categories = array(
                    array(
                        'name' => 'Women',
                        'subtitle' => 'Elegant & Contemporary',
                        'image' => 'https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=500&h=600&fit=crop',
                        'link' => '#'
                    ),
                    array(
                        'name' => 'Men',
                        'subtitle' => 'Classic & Modern',
                        'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=500&h=600&fit=crop',
                        'link' => '#'
                    ),
                    array(
                        'name' => 'Accessories',
                        'subtitle' => 'Complete Your Look',
                        'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=500&h=600&fit=crop',
                        'link' => '#'
                    )
                );
                
                foreach ($demo_categories as $category) {
                    ?>
                    <a href="<?php echo esc_url($category['link']); ?>" class="category-card">
                        <img src="<?php echo esc_url($category['image']); ?>" alt="<?php echo esc_attr($category['name']); ?>">
                        <div class="category-overlay">
                            <h3 class="category-title"><?php echo esc_html($category['name']); ?></h3>
                            <p class="category-subtitle"><?php echo esc_html($category['subtitle']); ?></p>
                        </div>
                    </a>
                    <?php
                }
            }
            ?>
        </div>
    </div>
</section>

<!-- Promotional Banner -->
<section class="promo-banner">
    <div class="container">
        <div class="promo-content">
            <h2><?php echo esc_html(get_theme_mod('promo_title', 'SUMMER SALE')); ?></h2>
            <p><?php echo esc_html(get_theme_mod('promo_subtitle', 'Up to 50% off selected items')); ?></p>
            <a href="<?php echo class_exists('WooCommerce') ? esc_url(wc_get_page_permalink('shop')) : '#'; ?>" class="promo-btn">Shop Sale</a>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<section class="newsletter-section">
    <div class="container">
        <div class="newsletter-content">
            <h3>Stay in Style</h3>
            <p>Subscribe to our newsletter for the latest fashion updates, exclusive offers, and style tips.</p>
            
            <form class="newsletter-form" id="newsletter-form">
                <input type="email" class="newsletter-input" placeholder="Enter your email address" required>
                <button type="submit" class="newsletter-btn">Subscribe</button>
            </form>
            
            <div id="newsletter-message" style="margin-top: 20px; display: none;"></div>
        </div>
    </div>
</section>

<?php get_footer(); ?>