<?php
/**
 * The main template file
 * Fashion Boutique Theme
 */

get_header(); 

// Check if this is the blog index being used as front page (no static front page set)
if (is_front_page() && is_home() && get_option('show_on_front') !== 'page') {
    // This is the main blog index being used as front page
    // Show the fashion boutique homepage layout
    ?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="hero-content">
        <h1><?php echo esc_html(get_theme_mod('hero_title', 'Elegant Fashion for Modern Women')); ?></h1>
        <p><?php echo esc_html(get_theme_mod('hero_subtitle', 'Discover our curated collection of timeless pieces')); ?></p>
        <a href="<?php echo esc_url(get_theme_mod('hero_button_link', class_exists('WooCommerce') ? wc_get_page_permalink('shop') : '#')); ?>" class="btn btn-primary">
            <?php echo esc_html(get_theme_mod('hero_button_text', 'Shop Now')); ?>
        </a>
    </div>
</section>

<!-- Featured Products Section -->
<section class="featured-products section-padding">
    <div class="container">
        <div class="section-title">
            <h2>Featured Products</h2>
            <p>Handpicked items from our latest collection</p>
        </div>
        
        <div class="products-grid">
            <?php 
            // Check if WooCommerce is active
            if (class_exists('WooCommerce')) {
                $featured_products = get_featured_products(4);
                
                if (!empty($featured_products)) {
                    foreach ($featured_products as $product_post) {
                        $product = wc_get_product($product_post->ID);
                        ?>
                        <div class="product-card fade-in">
                            <div class="product-image">
                                <?php if (has_post_thumbnail($product_post->ID)) : ?>
                                    <?php echo get_the_post_thumbnail($product_post->ID, 'woocommerce_thumbnail'); ?>
                                <?php else : ?>
                                    <img src="https://via.placeholder.com/300x400/f8f8f8/333?text=Product" alt="<?php echo esc_attr($product->get_name()); ?>">
                                <?php endif; ?>
                                
                                <div class="product-overlay">
                                    <button class="quick-add-btn" data-product-id="<?php echo $product->get_id(); ?>">
                                        Quick Add
                                    </button>
                                </div>
                            </div>
                            
                            <div class="product-info">
                                <h3 class="product-name">
                                    <a href="<?php echo get_permalink($product_post->ID); ?>">
                                        <?php echo esc_html($product->get_name()); ?>
                                    </a>
                                </h3>
                                
                                <div class="product-price">
                                    <?php echo $product->get_price_html(); ?>
                                </div>
                                
                                <button class="add-to-cart-btn" data-product-id="<?php echo $product->get_id(); ?>">
                                    Add to Cart
                                </button>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    // Fallback demo products if no WooCommerce products exist
                    $demo_products = array(
                        array('name' => 'Elegant Dress', 'price' => '$199', 'image' => 'https://images.unsplash.com/photo-1515372039744-b8f02a3ae446?w=300&h=400&fit=crop'),
                        array('name' => 'Designer Handbag', 'price' => '$299', 'image' => 'https://images.unsplash.com/photo-1548036328-c9fa89d128fa?w=300&h=400&fit=crop'),
                        array('name' => 'Luxury Heels', 'price' => '$249', 'image' => 'https://images.unsplash.com/photo-1543163521-1bf539c55dd2?w=300&h=400&fit=crop'),
                        array('name' => 'Fashion Jacket', 'price' => '$349', 'image' => 'https://images.unsplash.com/photo-1551028719-00167b16eac5?w=300&h=400&fit=crop')
                    );
                    
                    foreach ($demo_products as $product) {
                        ?>
                        <div class="product-card fade-in">
                            <div class="product-image">
                                <img src="<?php echo esc_url($product['image']); ?>" alt="<?php echo esc_attr($product['name']); ?>">
                                <div class="product-overlay">
                                    <button class="quick-add-btn">Quick Add</button>
                                </div>
                            </div>
                            
                            <div class="product-info">
                                <h3 class="product-name"><?php echo esc_html($product['name']); ?></h3>
                                <div class="product-price"><?php echo esc_html($product['price']); ?></div>
                                <button class="add-to-cart-btn">Add to Cart</button>
                            </div>
                        </div>
                        <?php
                    }
                }
            } else {
                // Demo products when WooCommerce is not installed
                $demo_products = array(
                    array('name' => 'Elegant Dress', 'price' => '$199', 'image' => 'https://images.unsplash.com/photo-1515372039744-b8f02a3ae446?w=300&h=400&fit=crop'),
                    array('name' => 'Designer Handbag', 'price' => '$299', 'image' => 'https://images.unsplash.com/photo-1548036328-c9fa89d128fa?w=300&h=400&fit=crop'),
                    array('name' => 'Luxury Heels', 'price' => '$249', 'image' => 'https://images.unsplash.com/photo-1543163521-1bf539c55dd2?w=300&h=400&fit=crop'),
                    array('name' => 'Fashion Jacket', 'price' => '$349', 'image' => 'https://images.unsplash.com/photo-1551028719-00167b16eac5?w=300&h=400&fit=crop')
                );
                
                foreach ($demo_products as $product) {
                    ?>
                    <div class="product-card fade-in">
                        <div class="product-image">
                            <img src="<?php echo esc_url($product['image']); ?>" alt="<?php echo esc_attr($product['name']); ?>">
                            <div class="product-overlay">
                                <button class="quick-add-btn">Quick Add</button>
                            </div>
                        </div>
                        
                        <div class="product-info">
                            <h3 class="product-name"><?php echo esc_html($product['name']); ?></h3>
                            <div class="product-price"><?php echo esc_html($product['price']); ?></div>
                            <button class="add-to-cart-btn">Add to Cart</button>
                        </div>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>
</section>

<!-- Category Cards Section -->
<section class="category-section">
    <div class="container">
        <div class="section-title">
            <h2>Shop by Category</h2>
            <p>Find the perfect style for every occasion</p>
        </div>
        
        <div class="category-grid">
            <?php
            // Demo categories with high-quality fashion images
            $demo_categories = array(
                array(
                    'name' => 'Women',
                    'subtitle' => 'Elegant & Contemporary',
                    'image' => 'https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=500&h=600&fit=crop',
                    'link' => '#'
                ),
                array(
                    'name' => 'Men',
                    'subtitle' => 'Classic & Modern',
                    'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=500&h=600&fit=crop',
                    'link' => '#'
                ),
                array(
                    'name' => 'Accessories',
                    'subtitle' => 'Complete Your Look',
                    'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62?w=500&h=600&fit=crop',
                    'link' => '#'
                )
            );
            
            foreach ($demo_categories as $category) {
                ?>
                <a href="<?php echo esc_url($category['link']); ?>" class="category-card">
                    <img src="<?php echo esc_url($category['image']); ?>" alt="<?php echo esc_attr($category['name']); ?>">
                    <div class="category-overlay">
                        <h3 class="category-title"><?php echo esc_html($category['name']); ?></h3>
                        <p class="category-subtitle"><?php echo esc_html($category['subtitle']); ?></p>
                    </div>
                </a>
                <?php
            }
            ?>
        </div>
    </div>
</section>

<!-- Promotional Banner -->
<section class="promo-banner">
    <div class="container">
        <div class="promo-content">
            <h2><?php echo esc_html(get_theme_mod('promo_title', 'SUMMER SALE')); ?></h2>
            <p><?php echo esc_html(get_theme_mod('promo_subtitle', 'Up to 50% off selected items')); ?></p>
            <a href="#" class="promo-btn">Shop Sale</a>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<section class="newsletter-section">
    <div class="container">
        <div class="newsletter-content">
            <h3>Stay in Style</h3>
            <p>Subscribe to our newsletter for the latest fashion updates, exclusive offers, and style tips.</p>
            
            <form class="newsletter-form" id="newsletter-form">
                <input type="email" class="newsletter-input" placeholder="Enter your email address" required>
                <button type="submit" class="newsletter-btn">Subscribe</button>
            </form>
            
            <div id="newsletter-message" style="margin-top: 20px; display: none;"></div>
        </div>
    </div>
</section>

    <?php
} else {
    // This is a regular blog page or other index page
    ?>
    <div class="container">
        <div class="blog-content section-padding">
            <main id="main" class="site-main">
                
                <?php if (have_posts()) : ?>
                
                    <header class="page-header">
                        <?php if (is_home() && !is_front_page()) : ?>
                            <h1 class="page-title"><?php single_post_title(); ?></h1>
                        <?php elseif (is_search()) : ?>
                            <h1 class="page-title">
                                <?php printf(esc_html__('Search Results for: %s', 'fashion-boutique'), '<span>' . get_search_query() . '</span>'); ?>
                            </h1>
                        <?php elseif (is_archive()) : ?>
                            <h1 class="page-title">
                                <?php the_archive_title(); ?>
                            </h1>
                        <?php endif; ?>
                    </header>
                    
                    <div class="posts-grid">
                        <?php while (have_posts()) : the_post(); ?>
                            
                            <article id="post-<?php the_ID(); ?>" <?php post_class('blog-post-card'); ?>>
                                
                                <?php if (has_post_thumbnail()) : ?>
                                <div class="post-thumbnail">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('medium'); ?>
                                    </a>
                                </div>
                                <?php endif; ?>
                                
                                <div class="post-content">
                                    <header class="entry-header">
                                        <?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '">', '</a></h2>'); ?>
                                        
                                        <div class="entry-meta">
                                            <span class="posted-on">
                                                <time class="entry-date" datetime="<?php echo esc_attr(get_the_date(DATE_W3C)); ?>">
                                                    <?php echo esc_html(get_the_date()); ?>
                                                </time>
                                            </span>
                                        </div>
                                    </header>
                                    
                                    <div class="entry-summary">
                                        <?php the_excerpt(); ?>
                                    </div>
                                    
                                    <footer class="entry-footer">
                                        <a href="<?php the_permalink(); ?>" class="read-more">
                                            <?php esc_html_e('Read More', 'fashion-boutique'); ?>
                                        </a>
                                    </footer>
                                </div>
                            </article>
                            
                        <?php endwhile; ?>
                    </div>
                    
                    <?php
                    the_posts_navigation(array(
                        'prev_text' => esc_html__('Older posts', 'fashion-boutique'),
                        'next_text' => esc_html__('Newer posts', 'fashion-boutique'),
                    ));
                    ?>
                    
                <?php else : ?>
                    
                    <section class="no-results not-found">
                        <header class="page-header">
                            <h1 class="page-title"><?php esc_html_e('Nothing here', 'fashion-boutique'); ?></h1>
                        </header>
                        
                        <div class="page-content">
                            <?php if (is_home() && current_user_can('publish_posts')) : ?>
                                
                                <p><?php printf(wp_kses(__('Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'fashion-boutique'), array('a' => array('href' => array()))), esc_url(admin_url('post-new.php'))); ?></p>
                                
                            <?php elseif (is_search()) : ?>
                                
                                <p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fashion-boutique'); ?></p>
                                <?php get_search_form(); ?>
                                
                            <?php else : ?>
                                
                                <p><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'fashion-boutique'); ?></p>
                                <?php get_search_form(); ?>
                                
                            <?php endif; ?>
                        </div>
                    </section>
                    
                <?php endif; ?>
                
            </main>
        </div>
        
        <?php get_sidebar(); ?>
    </div>
    <?php
}

get_footer(); ?>