<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site">
    <!-- Header Top Bar -->
    <div class="header-top">
        <div class="container">
            <p>Free shipping on orders over $100 | 30-day returns</p>
        </div>
    </div>

    <!-- Main Header -->
    <header id="masthead" class="site-header">
        <nav class="navbar">
            <div class="nav-container">
                <!-- Logo -->
                <div class="site-branding">
                    <?php
                    if (has_custom_logo()) {
                        the_custom_logo();
                    } else {
                        ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
                            <?php bloginfo('name'); ?>
                        </a>
                        <?php
                    }
                    ?>
                </div>

                <!-- Navigation Menu -->
                <div class="nav-menu-container">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_id'        => 'primary-menu',
                        'menu_class'     => 'nav-menu',
                        'container'      => false,
                        'fallback_cb'    => 'fashion_boutique_fallback_menu',
                    ));
                    ?>
                </div>

                <!-- Navigation Actions -->
                <div class="nav-actions">
                    <!-- Search -->
                    <div class="search-container">
                        <form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url('/')); ?>">
                            <input type="search" class="search-input" placeholder="Search products..." value="<?php echo get_search_query(); ?>" name="s">
                            <button type="submit" class="search-btn">
                                <i class="fas fa-search"></i>
                            </button>
                        </form>
                    </div>

                    <!-- Account -->
                    <a href="<?php echo class_exists('WooCommerce') ? esc_url(wc_get_account_endpoint_url('dashboard')) : '#'; ?>" class="account-icon">
                        <i class="fas fa-user"></i>
                    </a>

                    <!-- Shopping Cart -->
                    <a href="<?php echo class_exists('WooCommerce') ? esc_url(wc_get_cart_url()) : '#'; ?>" class="cart-icon">
                        <i class="fas fa-shopping-bag"></i>
                        <?php if (class_exists('WooCommerce') && WC()->cart->get_cart_contents_count() > 0) : ?>
                            <span class="cart-count" id="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                        <?php endif; ?>
                    </a>

                    <!-- Mobile Menu Toggle -->
                    <div class="mobile-toggle" id="mobile-toggle">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </div>
            </div>
        </nav>
    </header>

    <div id="content" class="site-content">

<?php
/**
 * Fallback menu if no menu is assigned
 */
function fashion_boutique_fallback_menu() {
    echo '<ul class="nav-menu">';
    echo '<li><a href="' . esc_url(home_url('/')) . '">Home</a></li>';
    if (class_exists('WooCommerce')) {
        echo '<li><a href="' . esc_url(wc_get_page_permalink('shop')) . '">Shop</a></li>';
    }
    echo '<li><a href="#">Women</a></li>';
    echo '<li><a href="#">Men</a></li>';
    echo '<li><a href="#">Accessories</a></li>';
    echo '<li><a href="#">Sale</a></li>';
    wp_list_pages(array(
        'title_li' => '',
        'number'   => 3,
    ));
    echo '</ul>';
}
?>