    </div><!-- #content -->

    <!-- Footer -->
    <footer id="colophon" class="site-footer">
        <div class="container">
            <div class="footer-content">
                <!-- Footer Column 1 - About -->
                <div class="footer-section">
                    <?php if (is_active_sidebar('footer-1')) : ?>
                        <?php dynamic_sidebar('footer-1'); ?>
                    <?php else : ?>
                        <h4>About Fashion Boutique</h4>
                        <p>We curate the finest fashion pieces for the modern, sophisticated woman. Our collection features timeless elegance with contemporary flair.</p>
                        
                        <!-- Social Media Links -->
                        <div class="social-icons">
                            <?php
                            $social_networks = array(
                                'facebook' => 'fab fa-facebook-f',
                                'instagram' => 'fab fa-instagram',
                                'twitter' => 'fab fa-twitter',
                                'pinterest' => 'fab fa-pinterest'
                            );
                            
                            foreach ($social_networks as $network => $icon_class) {
                                $url = get_theme_mod("social_{$network}");
                                if ($url) {
                                    echo '<a href="' . esc_url($url) . '" target="_blank" rel="noopener"><i class="' . esc_attr($icon_class) . '"></i></a>';
                                }
                            }
                            
                            // Default social links if none are set
                            if (!get_theme_mod('social_facebook') && !get_theme_mod('social_instagram') && !get_theme_mod('social_twitter') && !get_theme_mod('social_pinterest')) {
                                ?>
                                <a href="#" target="_blank"><i class="fab fa-facebook-f"></i></a>
                                <a href="#" target="_blank"><i class="fab fa-instagram"></i></a>
                                <a href="#" target="_blank"><i class="fab fa-twitter"></i></a>
                                <a href="#" target="_blank"><i class="fab fa-pinterest"></i></a>
                                <?php
                            }
                            ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Footer Column 2 - Quick Links -->
                <div class="footer-section">
                    <?php if (is_active_sidebar('footer-2')) : ?>
                        <?php dynamic_sidebar('footer-2'); ?>
                    <?php else : ?>
                        <h4>Quick Links</h4>
                        <ul>
                            <li><a href="<?php echo esc_url(home_url('/')); ?>">Home</a></li>
                            <?php if (class_exists('WooCommerce')) : ?>
                                <li><a href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>">Shop</a></li>
                            <?php endif; ?>
                            <li><a href="#">About Us</a></li>
                            <li><a href="#">Contact</a></li>
                            <li><a href="#">Size Guide</a></li>
                            <li><a href="#">Returns</a></li>
                        </ul>
                    <?php endif; ?>
                </div>

                <!-- Footer Column 3 - Customer Service -->
                <div class="footer-section">
                    <?php if (is_active_sidebar('footer-3')) : ?>
                        <?php dynamic_sidebar('footer-3'); ?>
                    <?php else : ?>
                        <h4>Customer Service</h4>
                        <ul>
                            <li><a href="#">Shipping Info</a></li>
                            <li><a href="#">Return Policy</a></li>
                            <li><a href="#">Track Your Order</a></li>
                            <li><a href="#">FAQ</a></li>
                            <li><a href="#">Customer Support</a></li>
                            <li><a href="#">Privacy Policy</a></li>
                        </ul>
                    <?php endif; ?>
                </div>

                <!-- Footer Column 4 - Contact & Payment -->
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <ul>
                        <li><i class="fas fa-map-marker-alt"></i> 123 Fashion Street, Style City, SC 12345</li>
                        <li><i class="fas fa-phone"></i> +1 (555) 123-4567</li>
                        <li><i class="fas fa-envelope"></i> hello@fashionboutique.com</li>
                    </ul>
                    
                    <!-- Payment Methods -->
                    <h4 style="margin-top: 30px;">We Accept</h4>
                    <div class="payment-methods">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/5/5e/Visa_Inc._logo.svg/200px-Visa_Inc._logo.svg.png" alt="Visa" style="height: 25px;">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/2/2a/Mastercard-logo.svg/200px-Mastercard-logo.svg.png" alt="Mastercard" style="height: 25px;">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/b/b5/PayPal.svg/200px-PayPal.svg.png" alt="PayPal" style="height: 25px;">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/fa/American_Express_logo_%282018%29.svg/200px-American_Express_logo_%282018%29.svg.png" alt="American Express" style="height: 25px;">
                    </div>
                </div>
            </div>

            <!-- Footer Bottom -->
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php bloginfo('name'); ?>. All rights reserved. | 
                   <a href="#">Terms of Service</a> | 
                   <a href="#">Privacy Policy</a>
                </p>
            </div>
        </div>
    </footer><!-- #colophon -->

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>